/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.StringTokenizer;

public class MultiLineLabel
extends Canvas {
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    protected String[] lines;
    protected int num_lines;
    protected int margin_width;
    protected int margin_height;
    protected int line_height;
    protected int line_ascent;
    protected int[] line_widths;
    protected int max_width;
    protected int alignment;

    protected void newLabel(String label) {
        StringTokenizer t = new StringTokenizer(label, "\n");
        this.num_lines = t.countTokens();
        this.lines = new String[this.num_lines];
        this.line_widths = new int[this.num_lines];
        int i = 0;
        while (i < this.num_lines) {
            this.lines[i] = t.nextToken();
            ++i;
        }
    }

    protected void measure() {
        FontMetrics fm = this.getFontMetrics(this.getFont());
        if (fm == null) {
            return;
        }
        this.line_height = fm.getHeight();
        this.line_ascent = fm.getAscent();
        this.max_width = 0;
        int i = 0;
        while (i < this.num_lines) {
            this.line_widths[i] = fm.stringWidth(this.lines[i]);
            if (this.line_widths[i] > this.max_width) {
                this.max_width = this.line_widths[i];
            }
            ++i;
        }
    }

    public MultiLineLabel(String label, int margin_width, int margin_height, int alignment) {
        this.newLabel(label);
        this.margin_width = margin_width;
        this.margin_height = margin_height;
        this.alignment = alignment;
    }

    public MultiLineLabel(String label, int margin_width, int margin_height) {
        this(label, margin_width, margin_height, 0);
    }

    public MultiLineLabel(String label, int alignment) {
        this(label, 10, 10, alignment);
    }

    public MultiLineLabel(String label) {
        this(label, 10, 10, 0);
    }

    public void setLabel(String label) {
        this.newLabel(label);
        this.measure();
        this.repaint();
    }

    public void setFont(Font f) {
        super.setFont(f);
        this.measure();
        this.repaint();
    }

    public void setForeground(Color c) {
        super.setForeground(c);
        this.repaint();
    }

    public void setAlignment(int a) {
        this.alignment = a;
        this.repaint();
    }

    public void setMarginWidth(int mw) {
        this.margin_width = mw;
        this.repaint();
    }

    public void setMarginHeight(int mh) {
        this.margin_height = mh;
        this.repaint();
    }

    public int getAlignment() {
        return this.alignment;
    }

    public int getMarginWidth() {
        return this.margin_width;
    }

    public int getMarginHeight() {
        return this.margin_height;
    }

    public void addNotify() {
        super.addNotify();
        this.measure();
    }

    public Dimension preferredSize() {
        return new Dimension(this.max_width + 2 * this.margin_width, this.num_lines * this.line_height + 2 * this.margin_height);
    }

    public Dimension minimumSize() {
        return new Dimension(this.max_width, this.num_lines * this.line_height);
    }

    public void paint(Graphics g) {
        Dimension d = this.size();
        int y = this.line_ascent + (d.height - this.num_lines * this.line_height) / 2;
        int i = 0;
        while (i < this.num_lines) {
            int x;
            switch (this.alignment) {
                case 0: {
                    x = this.margin_width;
                    break;
                }
                default: {
                    x = (d.width - this.line_widths[i]) / 2;
                    break;
                }
                case 2: {
                    x = d.width - this.margin_width - this.line_widths[i];
                }
            }
            g.drawString(this.lines[i], x, y);
            ++i;
            y += this.line_height;
        }
    }
}

