/*
   Phil's C Course - http://www.pottsoft.demon.co.uk/c_course/course.html

   Example 10         Phil Ottewell 1998 <phil@pottsoft.demon.co.uk>

   Purpose:
            Reading VMS keyed indexed files from DEC C
*/
/*---- Keyed Index File C Demonstration Program ("key.c") --------------------*/
/*
	History:
	Version		Name                    Date
	V01-001		Neill Clift             09-Mar-1995
			Initial version
*/

/* ANSI Headers */
#include <stddef.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

/* VMS Headers */
#include <rab.h>		/* RMS RAB */
#include <rms.h>		/* RMS access blocks etc */
#include <ssdef.h>		/* System service completion codes */
#include <starlet.h>
#include <lib$routines>

/* Defines and Macros */
#define NAME_SIZE  32        /* Size of person field */
#define PHONE_SIZE 20        /* Size of the phone number field */

/* Structure declarations */

struct phone_r {
/* Define the structure that will be the record of the keyed file. */
/* It is indexed  with two keys for each of the structures fields. */
   char name[NAME_SIZE];
   char phone[PHONE_SIZE];
};

/* Global Variables - not externally visible */
static struct FAB    fab;        /* FAB for file  */
static struct RAB    rab;        /* RAB for file */
static struct NAM    nam;        /* NAM block to report I/O errors nicely */
static struct XABKEY xabkey1, xabkey2;     /* XAB to define keys structure */

static char essbuf[NAM$C_MAXRSS];   /* Expanded file name */
static char rssbuf[NAM$C_MAXRSS];   /* Resultant file name */

static char keyname1[32] = "Person"; /* Name of first key */
static char keyname2[32] = "Phone";  /* Name of second key */

/*---- Routine to close the RMS file -----------------------------------------*/
int close_file( void )
{
   long int status;
/* End of declarations ... */

   status = sys$close( &fab );
   return( status );
}

/*---- Open/Create the keyed index file --------------------------------------*/
int create_file( char *filename )
{
   long int status, status1;
/* End of declarations ... */

   fab = cc$rms_fab;                    /* initialise the FAB */
   fab.fab$l_alq = 100;			/* Preallocate space */
   fab.fab$w_deq = 100;
   fab.fab$b_fac = FAB$M_PUT|FAB$M_DEL|FAB$M_UPD;
   fab.fab$l_fop = FAB$M_DFW|FAB$M_CIF;
   fab.fab$b_org = FAB$C_IDX;
   fab.fab$b_rfm = FAB$C_VAR;
   fab.fab$l_fna = filename;
   fab.fab$b_fns = strlen(filename);
   fab.fab$b_rat = FAB$M_CR;
   fab.fab$l_xab = (char *) &xabkey1;

   /* Init XABKEY to define key for name key */
   xabkey1 = cc$rms_xabkey;		/* Initialise XABKEY structure */
   xabkey1.xab$b_bln  = XAB$C_KEYLEN;
   xabkey1.xab$b_cod  = XAB$C_KEY;
   xabkey1.xab$b_dtp  = XAB$C_STG;
   xabkey1.xab$b_ref  = 0;              /* Key zero */
   xabkey1.xab$l_knm  = (char *) &keyname1; /* Key name */
   xabkey1.xab$l_nxt  = (char *) &xabkey2;  /* Next XAB in chain */
   /*
      The next two fields describe the section of the record that contain the
      key.
   */
   xabkey1.xab$w_pos0 = offsetof(struct phone_r, name);
   xabkey1.xab$b_siz0 = NAME_SIZE;

   /* Init XABKEY to define key for phone kek */
   xabkey2 = cc$rms_xabkey;		/* Initialise XABKEY structure */
   xabkey2.xab$b_bln  = XAB$C_KEYLEN;
   xabkey2.xab$b_cod  = XAB$C_KEY;
   xabkey2.xab$b_dtp  = XAB$C_STG;
   xabkey2.xab$b_ref  = 1;              /* Key one */
   xabkey2.xab$l_knm  = (char *) &keyname2;
   xabkey2.xab$l_nxt  = 0;
   xabkey2.xab$w_pos0 = offsetof(struct phone_r, phone);
   xabkey2.xab$b_siz0 = PHONE_SIZE;


   /*
      Init NAM block just for good file I/O error reporting. We won't use it
      thought!
   */

   nam = cc$rms_nam;
   fab.fab$l_nam = &nam;
   nam.nam$b_rss = sizeof( rssbuf );
   nam.nam$l_rsa = (char *) &rssbuf;
   nam.nam$b_ess = sizeof( essbuf );
   nam.nam$l_esa = (char *) &essbuf;
   status = sys$create( &fab );
   if (!(status&SS$_NORMAL))
      return( status );

   rab = cc$rms_rab;                    /* initialise the RAB */
   rab.rab$b_mbf = 127;
   rab.rab$b_mbc = 127;
   rab.rab$l_rop = RAB$M_WBH|RAB$M_RAH;;
   rab.rab$l_fab = &fab;
   status1 = sys$connect( &rab );
   if (!(status1&SS$_NORMAL)) {
      status = status1;
      sys$close( &fab );
   };
   return( status );
}

/*---- Write a record to the file --------------------------------------------*/
int put_record( char *name, char *phone )
{
   long int status;
   struct phone_r phonerec;
/* End of declarations ... */

   strncpy( phonerec.name,  name,  sizeof(phonerec.name) );
   strncpy( phonerec.phone, phone, sizeof(phonerec.phone) );
   rab.rab$w_rsz = sizeof( phonerec );
   rab.rab$l_rbf = (char *) &phonerec;
   rab.rab$b_rac = RAB$C_KEY;
   rab.rab$l_rop |= RAB$M_UIF;

   status = sys$put( &rab );

   return( status );
}

/*---- Look a record up by name ----------------------------------------------*/
int get_record( char *name, struct phone_r *phonerec )
{
   long int status;
/* End of declarations ... */

   rab.rab$w_usz = sizeof( *phonerec );
   rab.rab$l_ubf = (char *) phonerec;
   rab.rab$b_ksz = strlen( name );
   rab.rab$l_kbf = (char *) name;
   rab.rab$b_krf = 0;
   rab.rab$b_rac = RAB$C_KEY;
   rab.rab$l_rop |= RAB$M_UIF;

   status = sys$get( &rab );

   return( status );
}

/*---- Main Program starts here ----------------------------------------------*/
int main( int argc, char *argv[] )
{
   long int status;
   struct phone_r phn;
/* End of declarations ... */
   
   printf("Creating phone.dat ...\n");
   status = create_file("phone.dat");
   if (!(status&SS$_NORMAL)) lib$signal( status );

   printf("Add record NEILL - 555 555 1417\n");
   status = put_record ("NEILL", "555 555 1417");
   if (!(status&SS$_NORMAL)) lib$signal( status );

   printf("Add record PHIL - 555 555 6506\n");
   status = put_record ("PHIL", "555 555 6506");
   if (!(status&SS$_NORMAL)) lib$signal( status );

   printf("Look record for PHIL\n");
   status = get_record ("PHIL", &phn);
   if (!(status&SS$_NORMAL)) {
      lib$signal( status );
   } else {
      printf("Found %s - %s\n", phn.name, phn.phone );
   }

   status = close_file();
   if (!(status&SS$_NORMAL)) lib$signal (status);

   exit(EXIT_SUCCESS);
}
