% Example continuous-time (analog) exponential signal
% Course: Analog and Digital Filter Design
% Lecture: Review Signals
% Authors: Miroslav D. Lutovac, Dejan V. Tosic
% Email: lutovac@kondor.etf.bg.ac.yu
% Web: http://kondor.etf.bg.ac.yu/~lutovac/
% Copyright (c) 2004 by Lutovac & Tosic
% $Revision: 1.00 $  $Date: 2004/11/29$
% See also: Miroslav D. Lutovac, Dejan V. Tosic, Brian L. Evans
%  Filter Design for Signal Processing Using MATLAB and Mathematica
%  Prentice Hall (c)2001. ISBN 0-201-36130-2

clear all, close all, clc

Xe  = 0.8;
b = -0.5;

analogSignal = inline('Xe*exp(b*t)', 't', 'Xe', 'b');

t1 = 0;
t2 = 8;
timeRange = [t1, t2];

fplot(analogSignal, timeRange, 2e-3, 1, '-', Xe, b)

xlabel('t')
ylabel('x_e')
title('x_e(t) = X_e e^{b t}')
grid on