% Example continuous-time (analog) unit step signal
% Course: Analog and Digital Filter Design
% Lecture: Review Signals
% Authors: Miroslav D. Lutovac, Dejan V. Tosic
% Email: lutovac@kondor.etf.bg.ac.yu
% Web: http://kondor.etf.bg.ac.yu/~lutovac/
% Copyright (c) 2004 by Lutovac & Tosic
% $Revision: 1.00 $  $Date: 2004/11/29$
% See also: Miroslav D. Lutovac, Dejan V. Tosic, Brian L. Evans
%  Filter Design for Signal Processing Using MATLAB and Mathematica
%  Prentice Hall (c)2001. ISBN 0-201-36130-2

clear all, close all, clc

e=1/100;
analogSignal = inline('(1/e)*((t>0)&(t<=e))', 't', 'e');

t1 = -1;
t2 = 5;
timeRange = [t1, t2];

fplot(analogSignal, timeRange, 1e-5, 1000, '-', e)

set(gca,'FontSize',16)
xlabel('t')
ylabel('p_\epsilon(t)')
title('Pulse function, \epsilon = 1/100')
axis([timeRange -0.1 1.1/e])
