% Example Fourier series spectrum
% Course: Analog and Digital Filter Design
% Lecture: Review Transforms
% Authors: Miroslav D. Lutovac, Dejan V. Tosic
% Email: lutovac@kondor.etf.bg.ac.yu
% Web: http://kondor.etf.bg.ac.yu/~lutovac/
% Copyright (c) 2005 by Lutovac & Tosic
% $Revision: 1.00 $  $Date: 2005/01/22$
% See also: Miroslav D. Lutovac, Dejan V. Tosic, Brian L. Evans
%  Filter Design for Signal Processing Using MATLAB and Mathematica
%  Prentice Hall (c)2001. ISBN 0-201-36130-2

clear all, close all, clc

a = 0.1;
t1 = -1;  t2 = 2;  tstep = 0.01;
t = t1:tstep:t2;

x = t - a - round(t);

nmax = 8;
n = 1:nmax;

Xm0 = -a; ksi0 = 0;
Xm = 1./(n*pi);

ksi = (pi/2)*(-1).^n;

y = Xm0*ones(size(t));
for k = 1:nmax;
  y = y + Xm(k)*cos(2*pi*k*t + ksi(k));
end;

plot(t,x,'r',t,y,'b');
xlabel('t');
legend('x(t)', 'Fourier series');

figure
n0 = [0, n];

subplot(3,1,1)
stem(n0,[Xm0, Xm],'.')
legend('amplitude spectrum')

subplot(3,1,2)
stem(n0,[ksi0, ksi],'.g')
legend('phase spectrum')

subplot(3,1,3)
stem(n0,[Xm0^2, (Xm.^2)/2],'.r')
xlabel('n');
legend('power spectrum')
