% e = y22ZeroShiftingElements(num, den)
% Singly Terminated Ladder Realization with Complex Zeros
% Authors: Dejan V. Tosic, Miroslav D. Lutovac
% Email: lutovac@kondor.etf.bg.ac.yu
% Web: http://kondor.etf.bg.ac.yu/~lutovac/
% Copyright (c) 2005 by Lutovac & Tosic
% $Revision: 1.00 $  $Date: 2005/02/20$
% See also: Miroslav D. Lutovac, Dejan V. Tosic, Brian L. Evans
%  Filter Design for Signal Processing Using MATLAB and Mathematica
%  Prentice Hall (c)2001. ISBN 0-201-36130-2

function e = y22ZeroShiftingElements(num, den)

[numEv, numOd] = polynomialEvenOddParts(num);
[denEv, denOd] = polynomialEvenOddParts(den);

if numEv == 0*(1:length(numEv))
  y21num = numOd; y21den = denEv;
  y22num = denOd; y22den = denEv;
else
  y21num = numEv; y21den = denOd;
  y22num = denEv; y22den = denOd;
end

z = roots(num);
z = sort(z(find(imag(z)>0)),'descend');
%z = z(length(z):-1:1);

num1 = y22den; 
den1 = y22num;
e = [];

for i=1:length(z)
  [L1, num2, den2] = extractLinearTerm(num1, den1, z(i));
  [L2, C2, num3, den3] = extractBiquad(num2, den2, z(i));
  e = [e, [L1, L2, C2]];
  disp(['L', num2str(2*i-1), ' = ', num2str(real(L1))]);
  disp(['L', num2str(2*i), ' = ', num2str(real(L2))]);
  disp(['C', num2str(2*i), ' = ', num2str(real(C2))]);
  num1 = num3; 
  den1 = den3;
end

Lg = num1(1)/den1(1);
e = [e, Lg];
disp(['L', num2str(2*i+1), ' = ', num2str(real(Lg))]);

e = real(e);
