% Example response of a discrete-time system
% Course: Analog and Digital Filter Design
% Lecture: Digital filters, FIR and IIR structures
% Authors: Miroslav D. Lutovac, Dejan V. Tosic
% Email: lutovac@kondor.etf.bg.ac.yu
% Web: http://kondor.etf.bg.ac.yu/~lutovac/
% Copyright (c) 2005 by Lutovac & Tosic
% $Revision: 1.00 $  $Date: 2005/03/11$
% See also: Miroslav D. Lutovac, Dejan V. Tosic, Brian L. Evans
%  Filter Design for Signal Processing Using MATLAB and Mathematica
%  Prentice Hall (c)2001. ISBN 0-201-36130-2

clear all, close all, clc

N = 80;
k = 0:(N-1);

b0 = 1;
b1 = -1;
b2 = 1;
B = [b0 b1 b2];

f = 1/8;
x = sin(2*pi*f*k+pi/6);
y = filter(B,1,x);

subplot(2,1,1)
systemFIR(0,0,4,5,10,'b')

subplot(2,1,2)
plot(k,x,'go', k,y,'bo',...
     k,x,'g-', k,y,'b-')
legend('input','output')
